import discord

from discord.ext import commands

import json

from datetime import datetime

# Charger la config

with open("config.json") as f:

    config = json.load(f)

ABSENCE_CHANNEL_ID = config["ABSENCE_CHANNEL_ID"]

ABSENCE_RESULT_CHANNEL_ID = config["ABSENCE_RESULT_CHANNEL_ID"]

ROLE_VIE_SCOLAIRE_ID = config["ROLE_VIE_SCOLAIRE_ID"]

FOOTER_TEXT = config["FOOTER_TEXT"]

FOOTER_ICON = config["FOOTER_ICON"]

class FaitButton(discord.ui.View):

    def __init__(self):

        super().__init__(timeout=None)

    @discord.ui.button(label="✅ Fait", style=discord.ButtonStyle.green)

    async def fait(self, interaction: discord.Interaction, button: discord.ui.Button):

        if ROLE_VIE_SCOLAIRE_ID not in [role.id for role in interaction.user.roles]:

            await interaction.response.send_message(

                "❌ Vous n'avez pas la permission pour marquer comme fait.",

                ephemeral=True

            )

            return

        button.disabled = True

        date_traitement = datetime.now().strftime("%d/%m/%Y %H:%M")

        await interaction.message.edit(view=self, content=f"📌 **Traité le {date_traitement}**")

        await interaction.response.send_message("✅ Marqué comme fait.", ephemeral=True)

class AbsenceModal(discord.ui.Modal, title="Régularisation d'absence/retard"):

    nom_prenom = discord.ui.TextInput(label="Nom Prénom RP", style=discord.TextStyle.short, required=True)

    classe = discord.ui.TextInput(label="Classe", style=discord.TextStyle.short, required=True)

    absence_ou_retard = discord.ui.TextInput(label="Absence ou retard ?", style=discord.TextStyle.short, required=True)

    quand = discord.ui.TextInput(label="Quand ?", style=discord.TextStyle.short, required=True)

    motif = discord.ui.TextInput(label="Motif", style=discord.TextStyle.long, required=True)

    async def on_submit(self, interaction: discord.Interaction):

        salon_result = interaction.client.get_channel(ABSENCE_RESULT_CHANNEL_ID)

        if salon_result is None:

            await interaction.response.send_message("❌ Salon des résultats introuvable.", ephemeral=True)

            return

        embed = discord.Embed(title="📋 Nouvelle régularisation", color=0x2f3136)

        embed.add_field(name="Nom Prénom RP", value=self.nom_prenom.value, inline=False)

        embed.add_field(name="Classe", value=self.classe.value, inline=False)

        embed.add_field(name="Absence ou retard ?", value=self.absence_ou_retard.value, inline=False)

        embed.add_field(name="Quand ?", value=self.quand.value, inline=False)

        embed.add_field(name="Motif", value=self.motif.value, inline=False)

        embed.set_footer(text=FOOTER_TEXT, icon_url=FOOTER_ICON)

        await salon_result.send(embed=embed, view=FaitButton())

        await interaction.response.send_message("✅ Votre régularisation a été envoyée.", ephemeral=True)

class AbsenceView(discord.ui.View):

    def __init__(self):

        super().__init__(timeout=None)

    @discord.ui.button(label="📌 Régulariser", style=discord.ButtonStyle.blurple)

    async def regulariser(self, interaction: discord.Interaction, button: discord.ui.Button):

        await interaction.response.send_modal(AbsenceModal())

class Absence(commands.Cog):

    def __init__(self, bot):

        self.bot = bot

    @commands.command(name="absence-setup")

    async def absence_setup(self, ctx):

        """Envoie l'embed de régularisation dans ABSENCE_CHANNEL_ID"""

        if not ctx.author.guild_permissions.administrator:

            await ctx.send("❌ Vous devez être administrateur pour utiliser cette commande.")

            return

        salon_absence = self.bot.get_channel(ABSENCE_CHANNEL_ID)

        if salon_absence is None:

            await ctx.send(f"❌ Erreur : salon introuvable avec l'ID `{ABSENCE_CHANNEL_ID}`")

            return

        # Vérifier permissions

        perms = salon_absence.permissions_for(ctx.guild.me)

        if not perms.send_messages:

            await ctx.send("❌ Le bot ne peut pas envoyer de messages dans ce salon.")

            return

        if not perms.embed_links:

            await ctx.send("❌ Le bot ne peut pas envoyer d'embed dans ce salon.")

            return

        # Supprimer anciens messages du bot

        try:

            async for msg in salon_absence.history(limit=50):

                if msg.author == self.bot.user:

                    await msg.delete()

        except Exception as e:

            await ctx.send(f"⚠ Impossible de nettoyer les anciens messages : `{e}`")

        # Envoi de l'embed

        try:

            embed = discord.Embed(

                title="📌 Régularisation d'absence/retard",

                description="Cliquez sur le bouton ci-dessous pour régulariser votre absence ou retard.",

                color=0x2f3136

            )

            embed.set_footer(text=FOOTER_TEXT, icon_url=FOOTER_ICON)

            await salon_absence.send(embed=embed, view=AbsenceView())

            await ctx.send("✅ Embed envoyé dans le salon de régularisation.")

        except Exception as e:

            await ctx.send(f"❌ Erreur lors de l'envoi de l'embed : `{e}`")

async def setup(bot):

    await bot.add_cog(Absence(bot))